% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/schema.R
\name{sdf_schema_json}
\alias{sdf_schema_json}
\alias{sdf_schema_viewer}
\title{Work with the schema}
\usage{
sdf_schema_json(
  x,
  parse_json = TRUE,
  simplify = FALSE,
  append_complex_type = TRUE
)

sdf_schema_viewer(
  x,
  simplify = TRUE,
  append_complex_type = TRUE,
  use_react = FALSE
)
}
\arguments{
\item{x}{An \code{R} object wrapping, or containing, a Spark DataFrame.}

\item{parse_json}{Logical. If \code{TRUE} then the JSON return value will be parsed into an R list.}

\item{simplify}{Logical. If \code{TRUE} then the schema will be folded into itself such that
\code{{"name" : "field1", "type" : {"type" : "array", "elementType" : "string", "containsNull" : true},
 "nullable" : true, "metadata" : { } }} will be rendered simply \code{{"field1 (array)" : "[string]"}}}

\item{append_complex_type}{Logical. This only matters if \code{parse_json=TRUE} and \code{simplify=TRUE}. 
In that case indicators will be included in the return value for array and struct types.}

\item{use_react}{Logical. If \code{TRUE} schemas will be rendered using \link[listviewer]{reactjson}.
Otherwise they will be rendered using \link[listviewer]{jsonedit} (the default). Using react works better
in some contexts (e.g. bookdown-rendered HTML) and has a different look & feel. It does however carry
an extra dependency on the \code{reactR} package suggested by \code{listviewer}.}
}
\description{
These functions support flexible schema inspection both algorithmically and in human-friendly ways.
}
\examples{
\dontrun{
library(testthat)
library(jsonlite)
library(sparklyr)
library(sparklyr.nested)
sample_json <- paste0(
  '{"aircraft_id":["string"],"phase_sequence":["string"],"phases (array)":{"start_point (struct)":',
  '{"segment_phase":["string"],"agl":["double"],"elevation":["double"],"time":["long"],',
  '"latitude":["double"],"longitude":["double"],"altitude":["double"],"course":["double"],',
  '"speed":["double"],"source_point_keys (array)":["[string]"],"primary_key":["string"]},',
  '"end_point (struct)":{"segment_phase":["string"],"agl":["double"],"elevation":["double"],',
  '"time":["long"],"latitude":["double"],"longitude":["double"],"altitude":["double"],',
  '"course":["double"],"speed":["double"],"source_point_keys (array)":["[string]"],',
  '"primary_key":["string"]},"phase":["string"],"primary_key":["string"]},"primary_key":["string"]}'
)

with_mock(
  # I am mocking functions so that the example works without a real spark connection
  spark_read_parquet = function(x, ...){return("this is a spark dataframe")},
  sdf_schema_json = function(x, ...){return(fromJSON(sample_json))},
  spark_connect = function(...){return("this is a spark connection")},
  
  # the meat of the example is here
  sc <- spark_connect(),
  spark_data <- spark_read_parquet(sc, path="path/to/data/*.parquet", name="some_name"),
  sdf_schema_viewer(spark_data)
)
}
}
\seealso{
\code{\link[sparklyr]{sdf_schema}}
}
