% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{kalmanUnivariate}
\alias{kalmanUnivariate}
\title{Univariate filtering (sequential processing) for fast KFS}
\usage{
kalmanUnivariate(X, a0_0, P0_0, A, Lambda, Sig_e, Sig_u)
}
\arguments{
\item{X}{n x p, numeric matrix of (stationary) time series}

\item{a0_0}{k x 1, initial state mean vector}

\item{P0_0}{k x k, initial state covariance matrix}

\item{A}{k x k, state transition matrix}

\item{Lambda}{p x k, measurement matrix}

\item{Sig_e}{p x p, measurement equation residuals covariance matrix (diagonal)}

\item{Sig_u}{k x k, state equation residuals covariance matrix}
}
\value{
logl log-likelihood of the innovations from the Kalman filter

at_t \eqn{k \times n}{k x n}, filtered state mean vectors

Pt_t \eqn{k \times k \times n}{k x k x n}, filtered state covariance matrices

at_n \eqn{k \times n}{k x n}, smoothed state mean vectors

Pt_n \eqn{k \times k \times n}{k x k x n}, smoothed state covariance matrices

Pt_tlag_n \eqn{k \times k \times n}{k x k x n}, smoothed state covariance with lag
}
\description{
Univariate treatment (sequential processing) of the multivariate Kalman filter and smoother equations for fast implementation. Refer to Koopman and Durbin (2000).
}
\details{
For full details of the univariate filtering approach, please refer to Mosley et al. (2023). Note that \eqn{n}{n} is the number of observations, \eqn{p}{p} is the number of time series, and \eqn{k}{k} is the number of states.
}
\references{
Koopman, S. J., & Durbin, J. (2000). Fast filtering and smoothing for multivariate state space models. \emph{Journal of Time Series Analysis, 21}(3), 281-296.

Mosley, L., Chan, TS., & Gibberd, A. (2023). sparseDFM: An R Package to Estimate Dynamic Factor Models with Sparse Loadings.
}
