## -----------------------------------------------------------------------------
library(specieschrom)

data("data_abundance")
data("environment")

## -----------------------------------------------------------------------------
sp_chrom_PS1<-chromato_env16(environment,data_abundance[,1],50,1,5,2)

## -----------------------------------------------------------------------------
sp_chrom_PS3<-chromato_env16(environment,data_abundance[,3],50,1,5,2)

## -----------------------------------------------------------------------------
sp_chrom_PS5<-chromato_env16(environment,data_abundance[,5],50,1,5,2)

## -----------------------------------------------------------------------------
sp_chrom_PS8<-chromato_env16(environment,data_abundance[,8],50,1,5,2)

## -----------------------------------------------------------------------------
library(abind)
test_PS<-abind::abind(sp_chrom_PS1,sp_chrom_PS3,sp_chrom_PS5,sp_chrom_PS8,along=3)

## -----------------------------------------------------------------------------
opti_ampli_niche<-opti_eury_niche2(test_PS,0,environment,data_abundance[,c(1,3,5,8)],5)


## -----------------------------------------------------------------------------
opti_ampli_niche$amplitudes

## -----------------------------------------------------------------------------
opti_ampli_niche$mean_amplitudes

## -----------------------------------------------------------------------------
opti_ampli_niche$optimums


## -----------------------------------------------------------------------------
Index_D_PS<-combina_niche3(test_PS,0)

## -----------------------------------------------------------------------------
Index_D_PS$combi_dim

## -----------------------------------------------------------------------------
Index_D_PS$sp_by_sp

## -----------------------------------------------------------------------------
Index_D_PS$dim_alone

