% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opti_eury_niche2.R
\name{opti_eury_niche2}
\alias{opti_eury_niche2}
\title{Optimums and amplitudes estimations along each niche dimension.}
\usage{
opti_eury_niche2(sp_chr, Thres_T, z, y, k)
}
\arguments{
\item{sp_chr}{a matrix with the species chromatograms (categories by environmental variables by species). Outputs of 'chromato_env16.R'}

\item{Thres_T}{an integer corresponding to the min abundance threshold for niche amplitudes estimations}

\item{z}{a matrix with n samples by p environmental variables (i.e. the value of each environmental variable in each sample). Same matrix as in 'chromato_env16.R'.}

\item{y}{a matrix with the species abundance in the n samples}

\item{k}{an integer corresponding to the percentage of samples with the highest abundance values to use to estimate the mean abundance in a given category. Should have the same value as in 'chromato_env16.R'}
}
\value{
Three matrices are returned:

amplitudes, a matrix with the degree of euryoecie (niche breadth) of each species (in column) along each environmental dimension (in line)

mean_amplitudes, a matrix with the mean degree of euryoecie of each species

optimums, a matrix with the niche optimum values of each species (in column) along each environmental dimension (in line)
}
\description{
Function that estimates niche optimums and amplitudes along each environmental variable and for each species.
}
\examples{
# Load the example datasets
data("data_abundance")
data("environment")
# Characterise and display the ecological niche of 2 pseudo-species
# `alpha`=50 categories, `m`=1 sample, `k`=5 and `order_smth`=2
sp_chrom_PS3<-chromato_env16(environment,data_abundance[,3],50,1,5,2)
sp_chrom_PS8<-chromato_env16(environment,data_abundance[,8],50,1,5,2)
# Combine the species chromatograms along a third dimension with `abind`
library(abind)
test_PS<-abind::abind(sp_chrom_PS3,sp_chrom_PS8,along=3)
# `opti_eury_niche2.R` can then be applied, with `Thres_T`=0 and `k`=5
opti_ampli_niche<-opti_eury_niche2(test_PS,0,environment,data_abundance[,c(3,8)],5)
}
