% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/case-write.R
\name{case_fishing}
\alias{case_fishing}
\title{Write a case file for fishing data to the disk.}
\usage{
case_fishing(years = 1, years_alter = NULL, fvals = 2, case, spp)
}
\arguments{
\item{years}{Vector of years for which \emph{F} values are specified,
if there is more than one fleet or season the catches must be ordered by
season:year:fishery (e.g., season1year1fishery1, season2year1fishery1,
season1year2fishery1). The actual vector does not have to correspond to
true years but must be the correct length (e.g., instead of
\code{2000:2004} you can use \code{1:5}). Use this argument to create
an index to old values. \code{years_alter} will use values in this vector.
For example, with two seasons and one fishery that operates for 4 years
you could use the following: \code{1:8}.}

\item{years_alter}{Vector of years for the which \emph{F} values will be altered.
If there is more than one fishery or season, use the mapping system
created in \code{years} because actual year values cannot be recycled.
For example, to change the second season of the second year in the
example above, use: \code{4}.}

\item{fvals}{Vector of \emph{F} values to be entered into \code{ss.par} file,
where \code{length(fvals) == length(years_alter)} must be true.}

\item{case}{The case number you want to write to.
If \code{case = 1}, then the result will be \code{'F1'}.}

\item{spp}{A vector of character values argument specifying the species.}
}
\description{
Use \R code to write arguments to the disk, which
will later be used in a \pkg{ss3sim} simulation.
}
\examples{
case_fishing(1:100, 1:100, seq(0, 0.4, length.out = 100), 2, "cod")
done <- file.remove("F2-cod.txt")
}
