% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/change_rec_devs_par.r
\name{change_rec_devs_par}
\alias{change_rec_devs_par}
\title{Replace recruitment deviations}
\usage{
change_rec_devs_par(recdevs_new, par_file_in = "ss.par",
  par_file_out = "ss.par")
}
\arguments{
\item{recdevs_new}{A vector of new recruitment deviations.}

\item{par_file_in}{A string providing the path to the input SS \code{.par} file.}

\item{par_file_out}{A string providing the path to the output SS \code{.par} file.}
}
\value{
A modified SS3 \code{.par} file.
}
\description{
This function replaces the recruitment deviations in the
\code{ss.par} file with those specified in \code{recdevs_new}, as
well as a comment (for debugging). It then writes a new file with
name \code{par_file_out} into the working directory.
}
\details{
This function does not need to be specified in a case file if you
  are running and ss3sim simulation through case files with
  \code{\link{run_ss3sim}}.
}
\author{
Cole Monnahan
}
