subnet <- function(data) {
  t <- netmeta::netconnection(treat1 = data$treat1, treat2 = data$treat2, studlab = data$studlab)

  ##
  nsub <- t$n.subnets # Number of sub-networks

  subnetworks <- list()
  for(i in 1:nsub){
    subnetworks[[paste(i)]] <- unique(c(t$treat1[which(t$subnet == i)], t$treat2[which(t$subnet == i)]))
  }

  dis_nodes <- list() # Disconnected nodes
  ndis <- 0

  for (i in 1:nsub) {
    if (length(subnetworks[[i]]) < max(unlist(lapply(subnetworks, length)))) {
      ndis <- ndis + 1
      dis_nodes[[ndis]] <- subnetworks[[i]]
    }
  }

  res <- list(
    "nsub" = nsub,
    "subnetworks" = subnetworks,
    "disnet" = dis_nodes
  )

  res
}
