% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_power_best_normal.R
\name{sim_power_best_normal}
\alias{sim_power_best_normal}
\title{Simulate Power to Select Best Group (Normal Outcomes)}
\usage{
sim_power_best_normal(
  noutcomes,
  sd,
  dif,
  ngroups,
  npergroup,
  nsim,
  conf.level = 0.95
)
}
\arguments{
\item{noutcomes}{Integer. Number of outcomes to evaluate.}

\item{sd}{Numeric vector. Standard deviations for each outcome. Can be a single value.}

\item{dif}{Numeric vector. Difference in means between the best and the other groups.}

\item{ngroups}{Number of groups to compare.}

\item{npergroup}{Number of subjects per group. Can be scalar or vector of length \code{ngroups}.}

\item{nsim}{Integer. Number of simulations to perform.}

\item{conf.level}{Numeric. Confidence level for the empirical power estimate}
}
\value{
An S3 object of class \code{empirical_power_result}, which contains
the estimated empirical power and its confidence interval. The object can
be printed, formatted, or further processed using associated S3 methods.
See also \code{\link{empirical_power_result}}.
}
\description{
Estimates the empirical power to identify the most promising group as the best,
when outcomes are normally distributed and independent.
}
\details{
The best group (group 1)
is assumed to have mean 0, and the rest of the groups have mean \code{-dif}.

Multiple outcomes can be evaluated simultaneously. The power is estimated as the
proportion of simulations where the most promising group is the best in all outcomes.

The number of subjects per group can be the same or specified per group. In either case,
the first group is assumed to be the most promising.
}
\examples{
  sim_power_best_normal(
   noutcomes = 2,
   sd = c(1, 1.2),
   dif = c(0.2, 0.25),
   ngroups = 3,
   npergroup = c(30, 25, 25),
   nsim = 1000
  )
}
\seealso{
\code{\link{empirical_power_result}}
}
