#' @export

cbm_est <- function(theta, dt, iter = 2000, lambda = 0) {
  nc <- length(theta)
  sigma_wn <- sqrt(sum(acos(cos(diff(theta)))^2)/(nc*dt))
  out <- list(sigma_cbm = sigma_wn, dt=dt, lambda=lambda)
  class(out) <- "cbm"
  return(out)
}


stoch_cbm_est <- function(S_1, S_2, dt, iter = 2000, lambda = 4, seed = 100) {
  w <- 6
  a <- NULL
  for (i in 1:(length(S_1) - w)) {
    a <- c(a, cor(S_1[i:(i + w)], S_2[(i):(i + w)]))
  }
  nc <- length(S_1)
  E_lik <- function(par) {
    rho_vec <- par[1:nc]
    sinr <- sum(sqrt(1 - rho_vec^2))
    cosr <- sum(rho_vec)
    sigma_wn <- sqrt(-2 * log(sqrt(sinr^2 + cosr^2) / nc) / dt)
    mu1 <- par[nc + 1]
    sigma1 <- par[nc + 2]
    mu2 <- par[nc + 3]
    sigma2 <- par[nc + 4]
    ff <- 0
    ff <- optim_loop_cbm(dt = dt, rho_vec = rho_vec, sigma_wn = sigma_wn, nc = nc, S_1 = S_1, S_2 = S_2, mu1 = mu1, mu2 = mu2, sigma1 = sigma1, sigma2 = sigma2)
    # kappa_vm<-2*lambda_vm/(sigma_vm)^2
    a <- sum(diff(rho_vec, 1)^2)
    return(-ff + nc * lambda * a) # 0.01 gigachad kappa also 0.1
  }

  xstart <- c(a, rep(0, w), 0.1, 0.1, 0.1, 0.1)
  # xstart<-c(runif(nc,-0.99,0.99),1,0.5,pi/2,0.17,0.12,0.001,0.46)
  lower_limit <- c(rep(-0.99999, nc), 0.0001, 0.0001, 0.0001, 0.0001)
  upper_limit <- c(rep(0.99999, nc), 1, 1, 1, 1)

  set.seed(seed)

  fulloptim <- nloptr::nloptr(
    x0 = xstart,
    eval_f = E_lik,
    lb = lower_limit,
    ub = upper_limit,
    opts = list(
      "algorithm" = "NLOPT_LN_BOBYQA",
      "xtol_rel" = 1.0e-8,
      "maxeval" = iter,
      "print_level" = 0
    )
  )
  rho_est <- fulloptim$solution[1:nc]
  sinr <- sum(sqrt(1 - rho_est^2))
  cosr <- sum(rho_est)
  sigma_wn_est <- sqrt(-2 * log(sqrt(sinr^2 + cosr^2) / nc) / dt)
  mu1_est <- fulloptim$solution[nc + 1]
  sigma1_est <- fulloptim$solution[nc + 2]
  mu2_est <- fulloptim$solution[nc + 3]
  sigma2_est <- fulloptim$solution[nc + 4]


  out <- list(rho = rho_est, sigma_cbm = sigma_wn_est, mu1 = mu1_est, sigma1 = sigma1_est, mu2 = mu2_est, sigma2 = sigma2_est, dt=dt, lambda = lambda)
  class(out) <- "cbm"

  set.seed(NULL)
  return(out)
}
