% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stop_smdda.R
\name{stop_smddae}
\alias{stop_smddae}
\title{STOPS version of sparsified multidimensional distance analysis for fixed eps and tau}
\usage{
stop_smddae(
  dis,
  theta = c(100, 100),
  type = "ratio",
  weightmat = 1 - diag(nrow(dis)),
  init = NULL,
  ndim = 2,
  itmaxi = 10000,
  ...,
  stressweight = 1,
  structures = c("cclusteredness", "clinearity", "cdependence", "cmanifoldness",
    "cassociation", "cnonmonotonicity", "cfunctionality", "ccomplexity", "cfaithfulness",
    "cregularity", "chierarchy", "cconvexity", "cstriatedness", "coutlying",
    "cskinniness", "csparsity", "cstringiness", "cclumpiness", "cinequality"),
  strucweight = rep(1/length(structures), length(structures)),
  strucpars,
  verbose = 0,
  stoptype = c("additive", "multiplicative"),
  registry = struc_reg
)
}
\arguments{
\item{dis}{numeric matrix or dist object of a matrix of proximities}

\item{theta}{the theta vector of explicit parameters; first is tau for the neighboourhood, second is epsilon for isomapdist. Defaults to 100, 100.}

\item{type}{MDS type.}

\item{weightmat}{(optional) a matrix of nonnegative weights}

\item{init}{(optional) initial configuration}

\item{ndim}{number of dimensions of the target space}

\item{itmaxi}{number of iterations}

\item{...}{additional arguments to be passed to the fitting procedure}

\item{stressweight}{weight to be used for the fit measure; defaults to 1}

\item{structures}{a character vector listing the structure indices to use. They always are called "cfoo" with foo being the structure.}

\item{strucweight}{weight to be used for the structures; defaults to 1/number of structures}

\item{strucpars}{a list of parameters for the structuredness indices; each list element corresponds to one index in the order of the appearance in structures}

\item{verbose}{numeric value hat prints information on the fitting process; >2 is extremely verbose}

\item{stoptype}{which weighting to be used in the multi-objective optimization? Either 'additive' (default) or 'multiplicative'.}

\item{registry}{registry object with c-structuredness indices.}
}
\value{
A list with the components
\itemize{
        \item stress: the stress-1 value
        \item stress.m: default normalized stress
        \item stoploss: the weighted loss value
        \item struc: the structuredness indices
        \item parameters: the parameters used for fitting (tau)
        \item fit: the returned object of the fitting procedure
        \item{stopobj:} the stopobj object 
}
}
\description{
smdda with free parameters tau and epsilon.
}
\keyword{multivariate}
