% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/homog_ppp.R
\name{homog.STPP}
\alias{homog.STPP}
\title{Simulate a homogenous space-time Poisson process}
\usage{
homog.STPP(
  mu,
  poly,
  t.region,
  xfrac = 0.1,
  yfrac = 0.1,
  remove = FALSE,
  checkpoly = TRUE,
  showplot = FALSE
)
}
\arguments{
\item{mu}{- background parameter}

\item{poly}{- matrix defining polygon (\eqn{N} x \eqn{2})}

\item{t.region}{- vector of two elements describing time span}

\item{xfrac}{- x fractional increase of polygon to handle boundary effects (default = .1)}

\item{yfrac}{- y fractional increase (default = .1)}

\item{remove}{- remove points outside polygon (default = FALSE)}

\item{checkpoly}{- check if polygon is proper (default = TRUE)}

\item{showplot}{- plot points (default = FALSE)}
}
\value{
A DataFrame containing \eqn{x},\eqn{y},\eqn{t}
}
\description{
This function simulates a homogenous space-time Poisson process on \eqn{W}, defined by polygon
}
\examples{
out = homog.STPP(0.5,matrix(c(0,0,1,1,0,1,1,0),ncol=2),c(0,10))  
}
