% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join.R
\name{\%s+\%}
\alias{\%s+\%}
\alias{oper_plus}
\alias{operator_add}
\alias{operator_plus}
\alias{\%stri+\%}
\title{Concatenate Two Character Vectors}
\usage{
e1 \%s+\% e2

e1 \%stri+\% e2
}
\arguments{
\item{e1}{a character vector or an object coercible to a character vector}

\item{e2}{a character vector or an object coercible to a character vector}
}
\value{
Returns a character vector.
}
\description{
Binary operators for joining (concatenating) two character vectors,
with a typical R look-and-feel.
}
\details{
Vectorized over \code{e1} and \code{e2}.

These operators act like a call to \code{\link{stri_join}(e1, e2, sep='')}.
However, note that joining 3 vectors, e.g., \code{e1 \%s+\% e2 \%s+\% e3}
is slower than \code{\link{stri_join}(e1, e2, e3, sep='')},
because it creates a new (temporary) result vector each time
the operator is applied.
}
\examples{
c('abc', '123', 'xy') \%s+\% letters[1:6]
'ID_' \%s+\% 1:5

}
\seealso{
The official online manual of \pkg{stringi} at \url{https://stringi.gagolewski.com/}

Gagolewski M., \pkg{stringi}: Fast and portable character string processing in R, \emph{Journal of Statistical Software} 103(2), 2022, 1-59, \doi{10.18637/jss.v103.i02}

Other join: 
\code{\link{stri_dup}()},
\code{\link{stri_flatten}()},
\code{\link{stri_join}()},
\code{\link{stri_join_list}()}
}
\concept{join}
\author{
\href{https://www.gagolewski.com/}{Marek Gagolewski} and other contributors
}
