% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{loss_adapt_mlr3proba}
\alias{loss_adapt_mlr3proba}
\title{Adapt mlr3proba measures for use with survex}
\usage{
loss_adapt_mlr3proba(measure, reverse = FALSE, ...)
}
\arguments{
\item{measure}{\itemize{
\item a \code{MeasureSurv} object from the \code{mlr3proba} package, the object to adapt
}}

\item{reverse}{\itemize{
\item boolean, FALSE by default, whether the metric should be reversed in order to be treated as loss (for permutational variable importance we need functions with lower values indicating better performance). If TRUE, the new metric value will be (1 - metric_value)
}}

\item{...}{\itemize{
\item other parameters, currently ignored
}}
}
\value{
a function with standardized parameters (\code{y_true}, \code{risk}, \code{surv}, \code{times}) that can be used to calculate loss
}
\description{
This function allows for usage of standardized measures from the mlr3proba package with \code{survex}.
}
\examples{

if(FALSE){
  measure <- msr("surv.calib_beta")
  mlr_measure <- loss_adapt_mlr3proba(measure)
}

}
