% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survregVB.R
\name{survregVB.object}
\alias{survregVB.object}
\alias{print.survregVB}
\title{Variational Bayes Accelererated Failure Time Survival Model Object}
\description{
This class of objects is returned by the survregVB function to represent
a fitted parametric log-logistic accelerated failure time (AFT) survival
model. Objects of this class have methods for the functions \code{print}
and \code{summary}.
}
\details{
For approximate posterior distributions:
\itemize{
\item \eqn{q^*(\beta)}, a \eqn{N_p(\mu^*,\Sigma^*)} density function, and
\item \eqn{q^*(b)}, an \eqn{\text{Inverse-Gamma}(\alpha^*,\omega^*)}
density function,
}

the components of this class are:
\itemize{
\item \code{ELBO}: The final value of the Evidence Lower Bound (ELBO)
at the last iteration.
\item \code{alpha}: The shape parameter \eqn{\alpha^*} of \eqn{q^*(b)}.
\item \code{omega}: The scale parameter \eqn{\omega^*} of \eqn{q^*(b)}.
\item \code{mu}: Parameter \eqn{\mu^*} of \eqn{q^*(\beta)}, a vector
of means.
\item \code{Sigma}: Parameter \eqn{\Sigma^*} of \eqn{q^*(\beta)}, a
covariance matrix.
\item \code{na.action}: A missing-data filter function, applied to the
\code{model.frame}, after any subset argument has been used.
\item \code{iterations}: The number of iterations performed by the VB
algorithm: before converging or reaching \code{max_iteration}.
\item \code{n}: The number of observations.
\item \code{call}: The function call used to invoke the \code{survregVB}
method.
\item \code{not_converged}: A boolean indicating if the algorithm
converged.
\itemize{
\item \code{TRUE}: If the algorithm did not converge prior to
achieving \code{max_iteration}.
\item \code{NULL}: If the algorithm converged successfully.
}
}

If \code{survregVB} was called with shared frailty (with the \code{cluster}
argument), for approximate posterior distributions:
\itemize{
\item \eqn{q^*(\sigma^2_\gamma)}, an \eqn{\text{Inverse-Gamma}(\lambda^*,\eta^*)}
density function,
\item \eqn{q^*(\gamma_i)}, a \eqn{N(\tau^*_i,\sigma^{2*}_i)} density function,
for \eqn{i=1,...,K} clusters, and
}

the additional components are present:

\itemize{
\item \code{lambda}: The shape parameter \eqn{\lambda^*} of
\eqn{q^*(\sigma^2_\gamma)}.
\item \code{eta}: The scale parameter \eqn{\eta^*} of
\eqn{q^*(\sigma^2_\gamma)}.
\item \code{tau}: Parameter \eqn{\tau^*_i} of \eqn{q^*(\gamma_i)}, a
vector of means.
\item \code{sigma}: Parameter \eqn{\sigma^{2*}_i} of \eqn{q^*(\gamma_i)},
a vector of variance.
}
}
