% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estpoly.R
\name{bj}
\alias{bj}
\title{Estimate Box-Jenkins Models}
\usage{
bj(z, order = c(1, 1, 1, 1, 0), init_sys = NULL, options = optimOptions())
}
\arguments{
\item{z}{an \code{idframe} object containing the data}

\item{order}{Specification of the orders: the five integer components 
(nb,nc,nd,nf,nk) are order of polynomial B + 1, order of the polynomial C,
order of the polynomial D, order of the polynomial F, and the 
input-output delay respectively}

\item{init_sys}{Linear polynomial model that configures the initial parameterization.
Must be a BJ model. Overrules the \code{order} argument}

\item{options}{Estimation Options, setup using 
\code{\link{optimOptions}}}
}
\value{
An object of class \code{estpoly} containing the following elements:
 \item{sys}{an \code{idpoly} object containing the 
   fitted BJ coefficients}
 \item{fitted.values}{the predicted response}
 \item{residuals}{the residuals}
 \item{input}{the input data used}
 \item{call}{the matched call}
 \item{stats}{A list containing the following fields: \cr
     \code{vcov} - the covariance matrix of the fitted coefficients \cr
     \code{sigma} - the standard deviation of the innovations}
 \item{options}{Option set used for estimation. If no 
   custom options were configured, this is a set of default options}
 \item{termination}{Termination conditions for the iterative
    search used for prediction error minimization:
     \code{WhyStop} - Reason for termination \cr
     \code{iter} - Number of Iterations \cr
     \code{iter} - Number of Function Evaluations }
}
\description{
Fit a box-jenkins model of the specified order from input-output data
}
\details{
SISO BJ models are of the form 
\deqn{
   y[k] = \frac{B(q^{-1})}{F(q^{-1})}u[k-nk] + 
   \frac{C(q^{-1})}{D(q^{-1})} e[k]
}
The orders of Box-Jenkins model are defined as follows:
\deqn{
   B(q^{-1}) = b_1 + b_2q^{-1} + \ldots + b_{nb} q^{-nb+1}
}

\deqn{
   C(q^{-1}) = 1 + c_1q^{-1} + \ldots + c_{nc} q^{-nc}
}

\deqn{
   D(q^{-1}) = 1 + d_1q^{-1} + \ldots + d_{nd} q^{-nd}
}
\deqn{
   F(q^{-1}) = 1 + f_1q^{-1} + \ldots + f_{nf} q^{-nf}
}

The function estimates the coefficients using non-linear least squares 
(Levenberg-Marquardt Algorithm)
\cr
The data is expected to have no offsets or trends. They can be removed 
using the \code{\link{detrend}} function.
}
\examples{
data(bjsim)
z <- dataSlice(bjsim,end=1500) # training set
mod_bj <- bj(z,c(2,1,1,1,2))
mod_bj 
residplot(mod_bj) # residual plots

}
\references{
Arun K. Tangirala (2015), \emph{Principles of System Identification: 
Theory and Practice}, CRC Press, Boca Raton. Sections 14.4.1, 17.5.2, 
21.6.3
}

