% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6-ExprBuilder.R
\docType{class}
\name{ExprBuilder}
\alias{ExprBuilder}
\title{Frame expression builder}
\value{
In general, a modified \code{self} with extended expression.
}
\description{
Build an expression that will be used inside a \link[data.table:data.table-class]{data.table::data.table}'s frame. This
shouldn't be used directly.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{appends}}{Extra expressions that go at the end.}

\item{\code{expr}}{The final expression that can be evaluated with \code{\link[base:eval]{base::eval()}} or
\code{\link[rlang:eval_bare]{rlang::eval_bare()}}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ExprBuilder-new}{\code{ExprBuilder$new()}}
\item \href{#method-ExprBuilder-set_i}{\code{ExprBuilder$set_i()}}
\item \href{#method-ExprBuilder-set_j}{\code{ExprBuilder$set_j()}}
\item \href{#method-ExprBuilder-set_by}{\code{ExprBuilder$set_by()}}
\item \href{#method-ExprBuilder-chain}{\code{ExprBuilder$chain()}}
\item \href{#method-ExprBuilder-chain_if_set}{\code{ExprBuilder$chain_if_set()}}
\item \href{#method-ExprBuilder-seek_and_nestroy}{\code{ExprBuilder$seek_and_nestroy()}}
\item \href{#method-ExprBuilder-eval}{\code{ExprBuilder$eval()}}
\item \href{#method-ExprBuilder-tidy_select}{\code{ExprBuilder$tidy_select()}}
\item \href{#method-ExprBuilder-print}{\code{ExprBuilder$print()}}
\item \href{#method-ExprBuilder-clone}{\code{ExprBuilder$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExprBuilder-new"></a>}}
\if{latex}{\out{\hypertarget{method-ExprBuilder-new}{}}}
\subsection{Method \code{new()}}{
Constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExprBuilder$new(
  DT,
  dt_pronouns = list(),
  nested = list(),
  verbose = getOption("table.express.verbose", FALSE)
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{DT}}{A \link[data.table:data.table-class]{data.table::data.table}.}

\item{\code{dt_pronouns, nested}}{Internal parameters for joins.}

\item{\code{verbose}}{Print more information during the process of building expressions.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExprBuilder-set_i"></a>}}
\if{latex}{\out{\hypertarget{method-ExprBuilder-set_i}{}}}
\subsection{Method \code{set_i()}}{
Set the \code{i} clause expression(s), starting a new frame if the current
one already has said expression set.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExprBuilder$set_i(value, chain_if_needed)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{A captured expression.}

\item{\code{chain_if_needed}}{Whether chaining is allowed during this step.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExprBuilder-set_j"></a>}}
\if{latex}{\out{\hypertarget{method-ExprBuilder-set_j}{}}}
\subsection{Method \code{set_j()}}{
Like \code{set_i} but for the \code{j} clause.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExprBuilder$set_j(value, chain_if_needed)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{A captured expression.}

\item{\code{chain_if_needed}}{Whether chaining is allowed during this step.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExprBuilder-set_by"></a>}}
\if{latex}{\out{\hypertarget{method-ExprBuilder-set_by}{}}}
\subsection{Method \code{set_by()}}{
Set the \code{by} clause expression.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExprBuilder$set_by(value, chain_if_needed)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{A captured expression.}

\item{\code{chain_if_needed}}{Whether chaining is allowed during this step.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExprBuilder-chain"></a>}}
\if{latex}{\out{\hypertarget{method-ExprBuilder-chain}{}}}
\subsection{Method \code{chain()}}{
By default, start a new expression with the current one as its
parent. If \code{type = "pronoun"}, \code{dt} is used to start a new expression
that joins the current one.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExprBuilder$chain(type = "frame", next_dt, parent_env, to_eager = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{One of "frame", "pronoun".}

\item{\code{next_dt}}{Next data table when chaining pronoun.}

\item{\code{parent_env}}{Where to evaluate current expression when chaining
pronoun.}

\item{\code{to_eager}}{Whether or not to use an \link{EagerExprBuilder} in the
new chain}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExprBuilder-chain_if_set"></a>}}
\if{latex}{\out{\hypertarget{method-ExprBuilder-chain_if_set}{}}}
\subsection{Method \code{chain_if_set()}}{
Chain if any clause values are already set.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExprBuilder$chain_if_set(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Clause values.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExprBuilder-seek_and_nestroy"></a>}}
\if{latex}{\out{\hypertarget{method-ExprBuilder-seek_and_nestroy}{}}}
\subsection{Method \code{seek_and_nestroy()}}{
Helper for \code{nest_expr}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExprBuilder$seek_and_nestroy(.exprs)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{.exprs}}{List of expressions.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExprBuilder-eval"></a>}}
\if{latex}{\out{\hypertarget{method-ExprBuilder-eval}{}}}
\subsection{Method \code{eval()}}{
Evaluate the final expression with \code{parent_env} as the enclosing
environment. If \code{by_ref = FALSE}, \code{\link[data.table:copy]{data.table::copy()}} is called
before. The ellipsis' contents are assigned to the expression's
evaluation environment.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExprBuilder$eval(parent_env, by_ref, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{parent_env}}{Enclosing environment.}

\item{\code{by_ref}}{Flag to control deep copies.}

\item{\code{...}}{Additional variables for the evaluation environment.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExprBuilder-tidy_select"></a>}}
\if{latex}{\out{\hypertarget{method-ExprBuilder-tidy_select}{}}}
\subsection{Method \code{tidy_select()}}{
Evaluate a \code{tidyselect} call using the currently captured table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExprBuilder$tidy_select(select_expr)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{select_expr}}{The selection expression.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExprBuilder-print"></a>}}
\if{latex}{\out{\hypertarget{method-ExprBuilder-print}{}}}
\subsection{Method \code{print()}}{
Prints the built \code{expr}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExprBuilder$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Ignored.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExprBuilder-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ExprBuilder-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExprBuilder$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
