% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/themes.R
\name{xls_theme}
\alias{xls_theme}
\title{Constructor function for xls themes}
\usage{
xls_theme(
  title,
  col_header,
  character,
  footnote1,
  footnote2,
  footnote3,
  mergedcell,
  ...
)
}
\arguments{
\item{title}{Style for the title}

\item{col_header}{Style for the columns header}

\item{character}{Default style for data cells}

\item{footnote1}{Style for footnote1}

\item{footnote2}{Style for footnote2}

\item{footnote3}{Style for footnote3}

\item{mergedcell}{Style for merged cells}

\item{...}{Other (named) custom styles}
}
\value{
a named list of class xls_theme, whose elements are `openxlsx` Style objects.
}
\description{
This function creates an xls theme for styling exported tables.
All its arguments must be `openxlsx` Style objects.
}
\examples{
my_theme <- xls_theme(
  title = openxlsx::createStyle(),
  col_header = openxlsx::createStyle(),
  character = openxlsx::createStyle(),
  footnote1 = openxlsx::createStyle(),
  footnote2 = openxlsx::createStyle(),
  footnote3 = openxlsx::createStyle(),
  mergedcell = openxlsx::createStyle()
)

\dontrun{
toxlsx(object = iris, path = tempdir(), theme = my_theme)
}
}
\seealso{
\code{\link[tablexlsx:xls_theme_plain]{xls_theme_plain()}},
\code{\link[tablexlsx:xls_theme_default]{xls_theme_default()}}
}
