% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/naivebayes.R
\name{naivebayes}
\alias{naivebayes}
\title{Naive Bayes classifier}
\usage{
naivebayes(
  formula,
  data,
  weights = NULL,
  kernel = FALSE,
  laplace.smooth = 0,
  prior = NULL,
  ...
)
}
\arguments{
\item{formula}{Formula with syntax: response ~ predictors | weights}

\item{data}{data.frame}

\item{weights}{optional frequency weights}

\item{kernel}{If TRUE a kernel estimator is used for numeric predictors
(otherwise a gaussian model is used)}

\item{laplace.smooth}{Laplace smoothing}

\item{prior}{optional prior probabilities (default estimated from data)}

\item{...}{additional arguments to lower level functions}
}
\value{
An object of class '\code{naivebayes}' is returned. See
\code{\link{naivebayes-class}} for more details about this class and
its generic functions.
}
\description{
Naive Bayes Classifier
}
\examples{
library(data.table)
data(iris)
m <- naivebayes(Species ~ Sepal.Width + Petal.Length, data = iris)
pr <- predict(m, newdata = iris)

# using weights to reduce the size of the dataset
n <- 5e2
x <- rnorm(n, sd = 2) > 0
y <- rbinom(n, 1, lava::expit(x))
# full data set
d1 <- data.frame(y, x = as.factor(x > 0))
m1 <- naivebayes(y ~ x, data = d1)
# reduced data set
d2 <- data.table(d1)[, .(.N), by = .(y, x)]
m2 <- naivebayes(y ~ x, data = d2, weights = d2$N)
all(predict(m1, d1) == predict(m2, d1))
}
\author{
Klaus K. Holst
}
