% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text.table.R
\name{label_parts_of_speech}
\alias{label_parts_of_speech}
\title{Add a column with the parts of speech for each word in a text.table}
\usage{
label_parts_of_speech(x, text)
}
\arguments{
\item{x}{A text.table created by as.text.table().}

\item{text}{A string, the name of the column in x to label the parts of speech.}
}
\value{
A text.table, with columns added for the matching part of speech and  for flagging if the part of speech is for a multi-word phrase.
}
\description{
Add a column with the parts of speech for each word in a text.table
}
\examples{
label_parts_of_speech(
as.text.table(
  x = as.data.table(
    list(
      col1 = c(
        "a",
        "b"
      ),
      col2 = c(
        tolower("The dog is nice because it picked up the newspaper."),
        tolower("The dog is extremely nice because it does the dishes.")
      )
    )
  ),
  text = "col2",
  split = " "
),
text = "col2"
)
}
