% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text.table.R
\name{rm_short_words}
\alias{rm_short_words}
\title{Delete rows in a text.table where the word has less than a minimum number of characters}
\usage{
rm_short_words(x, text, min_char_length)
}
\arguments{
\item{x}{A text.table created by as.text.table().}

\item{text}{A string, the name of the column in x used to determine deletion of rows based on the number of characters.}

\item{min_char_length}{A number, the minimum number of characters required to not delete a row.}
}
\value{
A text.table, with rows having less than a certain number of characters deleted.
}
\description{
Delete rows in a text.table where the word has less than a minimum number of characters
}
\examples{
rm_short_words(
as.text.table(
  x = as.data.table(
    list(
      col1 = c(
        "a",
        "b"
      ),
      col2 = c(
        tolower("The dog is nice because it picked up the newspaper."),
        tolower("The dog is extremely nice because it does the dishes.")
      )
    )
  ),
  text = "col2",
  split = " "
),
text = "col2",
min_char_length = 4
)
}
