% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_ops.R
\name{img_sparse_image_warp}
\alias{img_sparse_image_warp}
\title{Sparse image warp}
\usage{
img_sparse_image_warp(
  image,
  source_control_point_locations,
  dest_control_point_locations,
  interpolation_order = 2,
  regularization_weight = 0,
  num_boundary_points = 0,
  name = "sparse_image_warp"
)
}
\arguments{
\item{image}{`[batch, height, width, channels]` float `Tensor`}

\item{source_control_point_locations}{`[batch, num_control_points, 2]` float `Tensor`}

\item{dest_control_point_locations}{`[batch, num_control_points, 2]` float `Tensor`}

\item{interpolation_order}{polynomial order used by the spline interpolation}

\item{regularization_weight}{weight on smoothness regularizer in interpolation}

\item{num_boundary_points}{How many zero-flow boundary points to include at each image edge.
Usage:
num_boundary_points=0: don't add zero-flow points
num_boundary_points=1: 4 corners of the image
num_boundary_points=2: 4 corners and one in the middle of each edge (8 points total)
num_boundary_points=n: 4 corners and n-1 along each edge}

\item{name}{A name for the operation (optional).}
}
\value{
warped_image: `[batch, height, width, channels]` float `Tensor` with
same type as input image. flow_field: `[batch, height, width, 2]`
float `Tensor` containing the dense flow field produced by the interpolation.
}
\description{
Image warping using correspondences between sparse control points.
}
\details{
Apply a non-linear warp to the image, where the warp is specified by
the source and destination locations of a (potentially small) number of
control points. First, we use a polyharmonic spline
(`tf$contrib$image$interpolate_spline`) to interpolate the displacements
between the corresponding control points to a dense flow field.
Then, we warp the image using this dense flow field
(`tf$contrib$image$dense_image_warp`). Let t index our control points.
For regularization_weight=0, we have:
warped_image[b, dest_control_point_locations[b, t, 0],
dest_control_point_locations[b, t, 1], :] =
image[b, source_control_point_locations[b, t, 0],
source_control_point_locations[b, t, 1], :]. For regularization_weight > 0,
this condition is met approximately, since
regularized interpolation trades off smoothness of the interpolant vs.
reconstruction of the interpolant at the control points.
See `tf$contrib$image$interpolate_spline` for further documentation of the
interpolation_order and regularization_weight arguments.
}
