% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{metric_cohen_kappa}
\alias{metric_cohen_kappa}
\title{Computes Kappa score between two raters}
\usage{
metric_cohen_kappa(
  num_classes,
  name = "cohen_kappa",
  weightage = NULL,
  sparse_labels = FALSE,
  regression = FALSE,
  dtype = NULL
)
}
\arguments{
\item{num_classes}{Number of unique classes in your dataset.}

\item{name}{(optional) String name of the metric instance}

\item{weightage}{(optional) Weighting to be considered for calculating kappa statistics.
A valid value is one of [None, 'linear', 'quadratic']. Defaults to `NULL`}

\item{sparse_labels}{(bool) Valid only for multi-class scenario. If True, ground truth
labels are expected tp be integers and not one-hot encoded}

\item{regression}{(bool) If set, that means the problem is being treated as a regression
problem where you are regressing the predictions. **Note:** If you are regressing for the
values, the the output layer should contain a single unit.}

\item{dtype}{(optional) Data type of the metric result. Defaults to `NULL`}
}
\value{
Input tensor or list of input tensors.
}
\description{
Computes Kappa score between two raters
}
\details{
The score lies in the range [-1, 1]. A score of -1 represents complete
disagreement between two raters whereas a score of 1 represents complete agreement
between the two raters. A score of 0 means agreement by chance.
}
\examples{

\dontrun{
model = keras_model_sequential() \%>\%
  layer_dense(units = 10, input_shape = ncol(iris) - 1,activation = activation_lisht) \%>\%
  layer_dense(units = 3)

model \%>\% compile(loss = 'categorical_crossentropy',
                  optimizer = optimizer_radam(),
                  metrics = metric_cohen_kappa(3))
}



}
