% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seq2seq.R
\name{sampler_custom}
\alias{sampler_custom}
\title{Base abstract class that allows the user to customize sampling.}
\usage{
sampler_custom(
  initialize_fn,
  sample_fn,
  next_inputs_fn,
  sample_ids_shape = NULL,
  sample_ids_dtype = NULL
)
}
\arguments{
\item{initialize_fn}{callable that returns (finished, next_inputs) for the first iteration.}

\item{sample_fn}{callable that takes (time, outputs, state) and emits tensor sample_ids.}

\item{next_inputs_fn}{callable that takes (time, outputs, state, sample_ids) and emits
(finished, next_inputs, next_state).}

\item{sample_ids_shape}{Either a list of integers, or a 1-D Tensor of type int32, the
shape of each value in the sample_ids batch. Defaults to a scalar.}

\item{sample_ids_dtype}{The dtype of the sample_ids tensor. Defaults to int32.}
}
\value{
None
}
\description{
Base abstract class that allows the user to customize sampling.
}
