% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_yes_no_unknown.R
\name{make_yes_no_unknown}
\alias{make_yes_no_unknown}
\title{make_yes_no_unknown}
\usage{
make_yes_no_unknown(x)
}
\arguments{
\item{x}{variable to be converted to hold "No", "Yes", or Unknown"}
}
\value{
a factor with "No", "Yes", or Unknown"
}
\description{
Convert a "Yes-No", "True-False" or "Checkboxes (Multiple
Answers)" question in REDCap to a factor holding "No" or
"Yes" or "Unknown". Technically "yes" or "checked" (ignoring case), 1 or
TRUE responses are converted to "Yes". "No" or "unchecked" (ignoring
case), 0 or FALSE are converted to "No".  All other values are set to
"Unknown". Also see \code{make_yes_no()}.
}
\examples{
make_yes_no_unknown(c(0, 1, NA))
make_yes_no_unknown(c("unchecked", "Checked", NA))
}
