% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_tilt.R
\name{read_tilt}
\alias{read_tilt}
\title{Read Multiple Tilt Data Files}
\usage{
read_tilt(path, file_type)
}
\arguments{
\item{path}{A character string specifying the path to the folder containing data files}

\item{file_type}{A function to read the files (e.g., readr::read_csv, read.table, etc.)}
}
\value{
A nested data frame with 'names' and 'contents' columns
}
\description{
Read in all tilt data files in a folder at once to create a nested data frame
that can be processed by other tidyrhrv functions.
}
\examples{
# Create toy HRV data files in temporary directory
temp_dir <- tempdir()

# Generate synthetic HRV data for two subjects
hrv_data1 <- data.frame(
  Time = seq(0, 60, by = 0.8),  # 60 seconds of data
  HR = 70 + rnorm(76, 0, 5),   # Heart rate around 70 bpm
  RR = 60/70 + rnorm(76, 0, 0.1) # RR intervals
)

hrv_data2 <- data.frame(
  Time = seq(0, 45, by = 0.7),  # 45 seconds of data  
  HR = 80 + rnorm(65, 0, 4),   # Heart rate around 80 bpm
  RR = 60/80 + rnorm(65, 0, 0.08)
)

# Write toy data files
write.csv(hrv_data1, file.path(temp_dir, "subject1.csv"), row.names = FALSE)
write.csv(hrv_data2, file.path(temp_dir, "subject2.csv"), row.names = FALSE)

# Read the data using read_tilt
tilt_data <- read_tilt(temp_dir, read.csv)
print(tilt_data)

# Clean up
unlink(file.path(temp_dir, c("subject1.csv", "subject2.csv")))

\donttest{
# Example with readr package (if available)
if (requireNamespace("readr", quietly = TRUE)) {
  # Create another toy data file
  write.csv(hrv_data1, file.path(temp_dir, "subject3.csv"), row.names = FALSE)
  
  # Read using readr::read_csv
  data_readr <- read_tilt(temp_dir, readr::read_csv)
  print(head(data_readr))
  
  # Clean up
  unlink(file.path(temp_dir, "subject3.csv"))
}
}
}
