% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_cpt_neighbors.R
\name{get_cpt_neighbors}
\alias{get_cpt_neighbors}
\title{Estimate the number of similar subjects}
\usage{
get_cpt_neighbors(.distance_matrix)
}
\arguments{
\item{.distance_matrix}{Matrix: a symmetric n x n matrix of distance values.}
}
\value{
Vector of positive integers: a vector of positive integers where the (i)th integer corresponds to the number of subjects (observations) that are similar to the (i)th subject.
}
\description{
Estimate the number of similar subjects using univariate multiple change point detection (i.e., binary segmentation in the changepoint package).
}
\examples{
# Import the tip library
library(tip)

# Choose an arbitrary random seed
set.seed(007)

# Generate some data (i.e., 20 subjects described by a 5 x 1 vector)
X <- matrix(rnorm(10*10),nrow=20,ncol=5)

# Compute the pairwise distances between the subjects
distance_matrix <- data.matrix(dist(X))

# For each subject, find the estimate for the number of similar subjects
get_cpt_neighbors(.distance_matrix = distance_matrix)
}
