% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot_line_point.R
\name{ggplot_line_point}
\alias{ggplot_line_point}
\title{Plot connected points using ggplot2}
\usage{
ggplot_line_point(.x, .y, .xlab = "", .ylab = "")
}
\arguments{
\item{.x}{The variable on the horizontal axis.}

\item{.y}{The variable on the vertical axis.}

\item{.xlab}{Character: the label on the horizontal axis.}

\item{.ylab}{Character: the label on the vertical axis.}
}
\value{
ggplot2 geom_line + geom_point plot: a ggplot2 plot of .y versus .x with a label .xlab on the horizontal axis and label .ylab on the vertical axis.
}
\description{
A function to that produces a ggplot2 plot of .y versus .x
where points are added via geom_point() and the points are connected via geom_line().
}
\examples{
# Import the tip library
library(tip)

# Create the variable that appears on the horizontal axis
x <- 1:10

# Create the variable that appears on the vertical axis
y <- rnorm(n = length(x), mean = 3, sd = 1)

# Create a label that appears on the horizontal axis
xlab <- "x"

# Create a label that appears on the vertical axis
ylab <- "y"

# Create the plot of y versus x with
ggplot_line_point(.x = x, .y = y, .xlab = xlab, .ylab = ylab)
}
