% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapgl_export.R
\name{tmap_mapbox}
\alias{tmap_mapbox}
\alias{tmap_maplibre}
\title{Export tmap to mapbox and maplibre}
\usage{
tmap_mapbox(x, show = FALSE, ...)

tmap_maplibre(x, show = FALSE, ...)
}
\arguments{
\item{x}{a tmap object.}

\item{show}{show the map?}

\item{...}{passed on to [`tmap`][tmap::print.tmap()]}
}
\value{
a [`mapgl`][mapgl::mapboxgl()] object (`"mapbox" mode`) or a [`mapgl`][mapgl::maplibregl()] object (`"maplibre"` mode). In case small multiples are shown, a list is returned.
}
\description{
* `tmap_mapbox()` returns a [`mapgl`][mapgl::mapboxgl()] object (`"mapbox" mode`)
* `tmap_maplibre()` a [`mapgl`][mapgl::maplibregl()] object (`"maplibre"` mode).
}
\examples{
library(tmap)
library(tmap.mapgl)
map = tm_shape(World) + tm_polygons()
tmap_maplibre(map, show = TRUE)
}
