% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allClasses.R, R/methods-TxpResultParam.R
\docType{class}
\name{TxpResultParam-class}
\alias{TxpResultParam-class}
\alias{TxpResultParam}
\title{ToxPi Result Parameters}
\arguments{
\item{rank.ties.method}{Passed to \code{rank.ties.method} slot}

\item{negative.value.handling}{Passed to \code{negative.value.handling} slot}
}
\description{
S4 class to store ToxPi result calculation parameters
}
\details{
If more than one value is passed to \code{TxoResultParam} scalar options, e.g.
\code{rank.ties.method}, only the first value is kept.

The \code{rank.ties.method} slot is passed to \link[base:rank]{base::rank} for calculating the
ranks of observations, with the highest-scoring observation having the rank
of 1.

\code{negative.value.handling} indicates how to handle negative values in the
inputs. The ToxPi algorithm originally intended to accept non-negative
potency values; the GUI, therefore, treats negative values in the input as
missing. By default, \link{txpCalculateScores} keeps negative values
(\code{negative.value.handling = "keep"}). To replicate the GUI behavior, users
can set \code{negative.value.handling = "missing"}.
}
\section{Slots}{

\describe{
\item{\code{rank.ties.method}}{Character scalar, method used to calculate score
ranks passed to \link[base:rank]{base::rank}}

\item{\code{negative.value.handling}}{Character scalar, how negative values are
handled, see details}
}}

\seealso{
\link{txpCalculateScores}, \link{TxpResult}
}
