% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecasting.R
\name{knn_forecasting}
\alias{knn_forecasting}
\title{Time series forecasting using KNN regression}
\usage{
knn_forecasting(
  timeS,
  h,
  lags = NULL,
  k = c(3, 5, 7),
  msas = c("recursive", "MIMO"),
  cf = c("mean", "median", "weighted"),
  transform = c("additive", "multiplicative", "none")
)
}
\arguments{
\item{timeS}{A numeric vector or time series of class \code{ts}.}

\item{h}{A positive integer. Number of values to forecast.}

\item{lags}{An integer vector in increasing order expressing the lags used
as autoregressive variables.}

\item{k}{A positive integer. The k parameter in KNN regression. A vector of
k values can also be used. In that case, the forecast is the average
of the forecasts produced by the different models with the different k
parameters.}

\item{msas}{A string indicating the Multiple-Step Ahead Strategy used when
more than one value is predicted. It can be "recursive" or "MIMO" (the
default).}

\item{cf}{A string. It indicates the combination function used to aggregate
the targets associated with the nearest neighbors. It can be "median",
"weighted" or "mean" (the default).}

\item{transform}{A character value indicating whether the training samples
are transformed. If the time series has a trend it is recommended. By
default is \code{"multiplicative"} (multiplicative transformation). It is also
possible a multiplicative transformation or no transformation.}
}
\value{
An object of class \code{"knnForecast"}. The
function \code{\link[base]{summary}} can be used to obtain or print a
summary of the results.

\if{html}{\out{<div class="sourceCode">}}\preformatted{An object of class \code{"knnForecast"} is a list containing at least
the following components:
}\if{html}{\out{</div>}}

\item{\code{call}}{the matched call.}
\item{\code{msas}}{the Multi-Step Ahead Strategy.}
\item{\code{prediction}}{a time series with the forecast.}
\item{\code{model}}{an object of class \code{"knnModel"} with the KNN
model}
}
\description{
It applies KNN regression to forecast the future values of a time series.
The lags used as autoregressive variables are set with the \code{lags}
parameter. If the user does not set the number of nearest neighbors or
the lags, these values are selected automatically.
}
\examples{
pred <- knn_forecasting(USAccDeaths, h = 12, lags = 1:12, k = 2)
pred$prediction # To see a time series with the forecasts
plot(pred) # To see a plot with the forecast
}
