% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_fil_lowess.R
\name{ts_fil_lowess}
\alias{ts_fil_lowess}
\title{LOWESS Smoothing}
\usage{
ts_fil_lowess(f = 0.2)
}
\arguments{
\item{f}{smoothing parameter. The larger this value, the smoother the series will be.
This provides the proportion of points on the plot that influence the smoothing.}
}
\value{
A \code{ts_fil_lowess} object.
}
\description{
Locally Weighted Scatterplot Smoothing (LOWESS) fits local
regressions to capture the primary trend while reducing noise and spikes.
}
\examples{
# time series with noise
library(daltoolbox)
data(tsd)
tsd$y[9] <- 2*tsd$y[9]

# filter
filter <- ts_fil_lowess(f = 0.2)
filter <- fit(filter, tsd$y)
y <- transform(filter, tsd$y)

# plot
plot_ts_pred(y=tsd$y, yadj=y)
}
\references{
\itemize{
\item W. S. Cleveland (1979). Robust locally weighted regression and smoothing
scatterplots. Journal of the American Statistical Association.
}
}
