% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_key_vars.R
\name{check_key_vars}
\alias{check_key_vars}
\title{Check Key Variables in List of Tibbles}
\usage{
check_key_vars(tibble_list, key_vars, verbose = FALSE)
}
\arguments{
\item{tibble_list}{A named list of tibbles, each containing an "id" column with question identifiers}

\item{key_vars}{A character vector of key variables to check for}

\item{verbose}{A logical value (TRUE or FALSE) specifying verbosity level.
If TRUE, reports tibbles that are removed and why.}
}
\value{
A list of tibbles that contain all required key variables
}
\description{
This function checks if specified key variables are present in each tibble's "id" column
and returns only tibbles that contain all required key variables.
}
\examples{
\dontrun{
# Create sample data
path <- file.path(find.package("tutorial.helpers"), "tests/testthat/fixtures/answers_html")

tibble_list <- gather_submissions(path, "stop")

result <- check_key_vars(tibble_list, 
                         key_vars = c("name", "email"))

}
}
