% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nibabynames.R
\docType{data}
\name{nibabynames}
\alias{nibabynames}
\title{Northern Ireland baby names}
\format{
A data frame with 22,596 observations on 6 variables.
\describe{
\item{year}{A year (1997-2020).}
\item{sex}{Sex, \code{M} for male and \code{F} for female.}
\item{name}{A name.}
\item{n}{Count of name within year and sex.}
\item{rank}{Rank of name within year and sex.}
\item{nation}{Nation of data source: \verb{Northern Ireland}.}
}
}
\source{
Northern Ireland Statistics and Research Agency. 2021. \href{https://www.nisra.gov.uk/publications/baby-names-2020-0}{Baby Names Statistics Boys and Girls}.
}
\usage{
nibabynames
}
\description{
Full baby name data from 1997 to 2020 for Northern Ireland
from the Northern Ireland Statistics and Research Agency.
}
\examples{
library(ggplot2)
library(dplyr)

nibabynames \%>\%
  filter(name == "Joseph") \%>\%
  ggplot(aes(x = year, y = n)) +
  geom_line() +
  labs(
    title = "Popularity of the name `Joseph` in Northern Ireland", 
    x = "Year", y = "Number of babies"
    )
}
\keyword{datasets}
