% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{ukppd_get}
\alias{ukppd_get}
\title{Get Price Paid Data}
\usage{
ukppd_get(
  postcode = "PL6 8RU",
  item = NULL,
  optional_item = NULL,
  start_date = NULL,
  end_date = NULL,
  ...
)
}
\arguments{
\item{postcode}{postcode to select, see \code{ukppd_avail_postcode()} for
available postcodes.}

\item{item}{item to select, see \code{ukppd_avail_items()} for
available items.}

\item{optional_item}{optional item to select that describes the location of
the transaction, , see \code{ukppd_avail_optional_items()} for available
items.}

\item{start_date}{the start date as YYYY-MM-DD.}

\item{end_date}{the end date as YYYY-MM-DD.}

\item{...}{query modifiers passed through \code{rdf_modifiers}.}
}
\value{
Returns a tibble in long format.
}
\description{
Price Paid Data tracks property sales in England and Wales submitted to HM Land
Registry for registration.  Price Paid Data is based on the raw data released each month.
}
\examples{
\donttest{
ukppd_get("PL6 8RU")

ukppd_get("PL6 8RU", start_date = "2001-01-01")

ukppd_get("PL6 8RU", item = "newBuild", optional_item = "street")
}
}
