% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Uni_Hamburg.R
\docType{data}
\name{uni_hamburg_1}
\alias{uni_hamburg_1}
\title{Primary colors of the University of Hamburg, Germany}
\format{
An object of class \code{character} of length 4.
}
\source{
Color definitions are based on the 
\href{https://www.fiona.uni-hamburg.de/beantragung/regelungen.html}{CD manual}.
}
\usage{
uni_hamburg_1
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{uni_hamburg_1} provides the four primary colors 
of the \href{https://www.uni-hamburg.de}{University of Hamburg}, Germany.
}
\details{
The two main colors are \code{"rot"} (also defined as Pantone 485C or CMYK 0/100/100/0) 
and \code{"blau"} (also defined as CMYK 87/49/0/0). 
These colors should be weighted equally and in a subtle fashion 
(i.e., as color accents, not large areas or entire texts).

The auxiliary colors \code{"black"} and 
\code{"steingrau"} (also defined as Pantone 432U or CMYK 45/11/11/73) 
are used for text.

Colors shades may be used in diagrams or visualizations. 
See examples and the \code{\link[unikn]{ac}} and \code{\link[unikn]{usecol}} functions 
for creating color gradients.
}
\examples{
uni_hamburg_1
unikn::seecol(uni_hamburg_1, main = "Primary colors of the University of Hamburg")
unikn::demopal(uni_hamburg_1, type = 3, main = "Primary colors of the Uni Hamburg")

# Color gradients:
unikn::seecol(unikn::usecol(c(uni_hamburg_1[1], uni_hamburg_1[2]), n = 6), 
              main = "HHU rot to blau")
unikn::seecol(unikn::usecol(c(uni_hamburg_1[1], "white", uni_hamburg_1[2]), n = 7), 
              main = "Divergent HHU")

}
\seealso{
\code{\link{uni_hamburg_2}} for visualization colors of the University of Hamburg;  
\code{\link[unikn]{seecol}} for viewing and comparing color palettes; 
\code{\link[unikn]{usecol}} for using color palettes; 
\code{\link[unikn]{simcol}} for finding similar colors; 
\code{\link[unikn]{newpal}} for defining new color palettes; 
\code{\link[unikn]{grepal}} for finding named colors.

Other German university color palettes: 
\code{\link{fu_0_2023}},
\code{\link{fu_1}},
\code{\link{fu_1_2023}},
\code{\link{fu_2}},
\code{\link{fu_2_2023}},
\code{\link{fu_3}},
\code{\link{fu_3_2023}},
\code{\link{fu_4}},
\code{\link{hu_1}},
\code{\link{hu_1_2022}},
\code{\link{hu_1_digital}},
\code{\link{hu_2}},
\code{\link{hu_2_2022}},
\code{\link{hu_3_accent}},
\code{\link{lmu_1}},
\code{\link{lmu_2}},
\code{\link{lmu_3}},
\code{\link{rptu}},
\code{\link{uni_bonn_1}},
\code{\link{uni_bonn_2}},
\code{\link{uni_freiburg_0}},
\code{\link{uni_freiburg_1}},
\code{\link{uni_freiburg_2}},
\code{\link{uni_freiburg_blue}},
\code{\link{uni_freiburg_br}},
\code{\link{uni_freiburg_grey}},
\code{\link{uni_freiburg_info}},
\code{\link{uni_goettingen_1}},
\code{\link{uni_goettingen_2}},
\code{\link{uni_goettingen_3}},
\code{\link{uni_halle}},
\code{\link{uni_hamburg_2}},
\code{\link{uni_heidelberg}},
\code{\link{uni_jena_1}},
\code{\link{uni_jena_2}},
\code{\link{uni_kassel}},
\code{\link{uni_kiel_1}},
\code{\link{uni_kiel_2}},
\code{\link{uni_koeln_1}},
\code{\link{uni_koeln_2}},
\code{\link{uni_konstanz_1}},
\code{\link{uni_konstanz_2}},
\code{\link{uni_magdeburg_1}},
\code{\link{uni_magdeburg_2}},
\code{\link{uni_magdeburg_3}},
\code{\link{uni_mannheim_1}},
\code{\link{uni_mannheim_2}},
\code{\link{uni_potsdam}},
\code{\link{uni_regensburg_1}},
\code{\link{uni_regensburg_2}},
\code{\link{uni_regensburg_3}},
\code{\link{uni_stuttgart_1}},
\code{\link{uni_stuttgart_print}},
\code{\link{uni_ulm_1}},
\code{\link{uni_ulm_2}}
}
\author{
\strong{unicol}, 2022-12-06.
}
\concept{German university color palettes}
\keyword{datasets}
