% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate.R
\name{closure_generate}
\alias{closure_generate}
\title{Generate CLOSURE samples}
\usage{
closure_generate(
  mean,
  sd,
  n,
  scale_min,
  scale_max,
  rounding = "up_or_down",
  threshold = 5,
  warn_if_empty = TRUE,
  ask_to_proceed = TRUE,
  rounding_error_mean = NULL,
  rounding_error_sd = NULL
)
}
\arguments{
\item{mean}{String (length 1). Reported mean.}

\item{sd}{String (length 1). Reported sample standard deviation.}

\item{n}{Numeric (length 1). Reported sample size.}

\item{scale_min, scale_max}{Numeric (length 1 each). Minimal and maximal
possible values of the measurement scale. For example, with a 1-7 Likert
scale, use \code{scale_min = 1} and \code{scale_max = 7}. Prefer the empirical min
and max if available: they constrain the possible values further.}

\item{rounding}{String (length 1). Rounding method assumed to have created
\code{mean} and \code{sd}. See \href{https://lhdjung.github.io/roundwork/articles/rounding-options.html}{\emph{Rounding options}},
but also the \emph{Rounding limitations} section below. Default is
\code{"up_or_down"} which, e.g., unrounds \code{0.12} to \code{0.115} as a lower bound and
\code{0.125} as an upper bound.}

\item{threshold}{Numeric (length 1). Number from which to round up or down,
if \code{rounding} is any of \code{"up_or_down"}, \code{"up"}, and \code{"down"}. Default is
\code{5}.}

\item{warn_if_empty}{Logical (length 1). Should a warning be shown if no
samples are found? Default is \code{TRUE}.}

\item{ask_to_proceed}{Logical (length 1). If the runtime is predicted to be
very long, should the function prompt you to proceed or abort in an
interactive setting? Default is \code{TRUE}.}

\item{rounding_error_mean, rounding_error_sd}{Numeric (length 1 each). Option
to manually set the rounding error around \code{mean} and \code{sd}. This is meant
for development and might be removed in the future, so most users can
ignore it.}
}
\value{
Named list of four tibbles (data frames):
\itemize{
\item \strong{\code{inputs}}: Arguments to this function.
\item \strong{\code{metrics}}:
\itemize{
\item \code{samples_initial}: integer. The basis for computing CLOSURE results,
based on scale range only. See \code{\link[=closure_count_initial]{closure_count_initial()}}.
\item \code{samples_all}: integer. Number of all samples. Equal to the number
of rows in \code{results}.
\item \code{values_all}: integer. Number of all individual values found. Equal to
\code{n * samples_all}.
\item \code{horns}: double. Measure of dispersion for bounded scales; see
\code{\link[=horns]{horns()}}.
\item \code{horns_uniform}: double. Value \code{horns} would have if the reconstructed
sample was uniformly distributed.
}
\item \strong{\code{frequency}}:
\itemize{
\item \code{value}: integer. Scale values derived from \code{scale_min} and
\code{scale_max}.
\item \code{f_average}: Count of scale values in the mean \code{results} sample.
\item \code{f_absolute}: integer. Count of individual scale values found in the
\code{results} samples.
\item \code{f_relative}: double. Values' share of total values found.
}
\item \strong{\code{results}}:
\itemize{
\item \code{id}: integer. Runs from \code{1} to \code{samples_all}.
\item \code{sample}: list of integer vectors. Each of these vectors has
length \code{n}. It is a sample (or distribution) of individual scale values
found by CLOSURE.
}
}
}
\description{
Call \code{closure_generate()} to run the CLOSURE algorithm on a
given set of summary statistics.

This can take seconds, minutes, or longer, depending on the input. Wide
variance and large \code{n} often lead to many samples, i.e., long runtimes.
These effects interact dynamically. For example, with large \code{n}, even very
small increases in \code{sd} can greatly increase runtime and number of values
found.

If the inputs are inconsistent, there is no solution. The function will
then return empty results and throw a warning.
}
\section{Rounding limitations}{
 The \code{rounding} and \code{threshold} arguments are
not fully implemented. For example, CLOSURE currently treats all rounding
bounds as inclusive, even if the \code{rounding} specification would imply
otherwise.

Many specifications of the two arguments will not make any difference, and
those that do will most likely lead to empty results.
}

\examples{
# High spread often leads to many samples --
# here, 3682.
data_high <- closure_generate(
  mean = "3.5",
  sd = "1.7",
  n = 70,
  scale_min = 1,
  scale_max = 5
)

data_high

# Get a clear picture of the distribution
# by following up with `closure_plot_bar()`:
closure_plot_bar(data_high)

# Low spread, only 3 samples, and not all
# scale values are possible.
data_low <- closure_generate(
  mean = "2.9",
  sd = "0.5",
  n = 70,
  scale_min = 1,
  scale_max = 5
)

data_low

# This can also be shown by `closure_plot_bar()`:
closure_plot_bar(data_low)
}
