% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/themes.R
\name{theme_basic}
\alias{theme_basic}
\title{Minimalist theme for ggplot2}
\usage{
theme_basic(
  base_size = 12,
  base_family = NULL,
  base_color = "black",
  base_line_size = base_size/12,
  base_rect_size = base_size/12
)
}
\arguments{
\item{base_size}{A numeric. Base font size.}

\item{base_family}{A numeric. Base font family.}

\item{base_color}{A character. Base color for lines and text.}

\item{base_line_size}{A numeric. Base line element size.}

\item{base_rect_size}{A numeric. Base rectangle element size.}
}
\description{
A minimalist \code{ggplot2} theme which removes most background elements and
lines.
}
\note{
Recommend exporting as PNG or TIFF to preserve
background transparency.
}
\examples{
library(ggplot2)

ggplot(datasets::mtcars, aes(x = wt, y = hp, color = as.factor(cyl))) +
  geom_point() +
  theme_basic()
}
