% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/valhalla.R
\name{map_isochrone}
\alias{map_isochrone}
\title{Generate maps of isochrones}
\usage{
map_isochrone(isochrone, method = "leaflet")
}
\arguments{
\item{isochrone}{An isochrone sf object generated by \code{valhallr::isochrone()}.}

\item{method}{The method used to map it. Two methods are supported:
\itemize{
\item "leaflet" produces an interactive HTML map using the Leaflet package.
\item "ggplot" produces a static map.
}}
}
\value{
A plot of the isochrones, either a a leaflet object or a ggplot object.
}
\description{
This is a convenience function that takes the output of \code{valhallr::isochrone()}
and generates either a static or interactive map.
}
\examples{
\dontrun{
library(valhallr)
# set up our departure point: the University of Ottawa
from <- test_data("uottawa")

# generate a set of isochrones for travel by bicycle
i <- valhallr::isochrone(from, costing = "bicycle")

# map the isochrones
map_isochrone(i)
}
}
