% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_predictions.R
\name{plot_predictions}
\alias{plot_predictions}
\title{Creates a ggplot object with a time series and some forecasts}
\usage{
plot_predictions(ts, future = NULL, predictions = NULL, sdp = TRUE)
}
\arguments{
\item{ts}{a time series of class \code{ts}.}

\item{future}{NULL (default) or a time series of class \code{ts} or a vector.
Future values of the time series.}

\item{predictions}{NULL (default) or a named list containing the predictions
for the future values. Each component of the list should contain a vector or
an object of class \code{ts} representing a forecast, the name of the
component should be the name of the forecasting method.}

\item{sdp}{logical. Should data points be shown? (default value \code{TRUE})}
}
\value{
The \code{ggplot} object representing the time series and its forecast.
}
\description{
Create a \code{ggplot} object with a time series and, optionally, some future
values of the time series and several forecast for those future values.
}
\details{
If \code{future} or the forecasts in the \code{prediction} list are vectors
then they are supposed to start after the last data of the time series.
}
\examples{
# plot a time series, its future values and two forecasts
ts <- window(USAccDeaths, end = c(1977, 12))
f <- window(USAccDeaths, start = c(1978, 1))
prediction1 <- rep(mean(ts), 12)
prediction2 <- as.vector(window(ts, start = c(1977, 1)))
p <- list(Mean = prediction1, Naive = prediction2)
plot_predictions(ts, future = f, predictions = p)
}
