% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dinuc.codon.R
\name{dinuc.codon}
\alias{dinuc.codon}
\title{Statistical dinucleotide over- and underrepresentation (codon model).}
\usage{
dinuc.codon(df.virus,permutations=500,exact_numbers = FALSE)
}
\arguments{
\item{df.virus}{data frame with seq_name and its DNA sequence.}

\item{permutations}{the number of permutations for the z-score computation.}

\item{exact_numbers}{if TRUE exact analytical calculation will be used.}
}
\value{
A data.frame containing the computed statistic for each dinucleotide in all DNA sequences within df.virus.
}
\description{
A measure of statistical dinucleotide over- and underrepresentation; by allows for random sequence generation by shuffling (with/without replacement) of codons.
}
\details{
For more information \href{https://www.rdocumentation.org/packages/seqinr/versions/3.6-1/topics/dinucleotides}{seqinr}.
}
\examples{
\dontshow{
file_path <- system.file("extdata", "sysdata.RData" ,package = "vhcub")
load(file = file_path)
}
\donttest{
# read DNA from fasta file
fasta <- fasta.read("virus.fasta", "host.fasta")
fasta.v <- fasta[[1]]
fasta.h <- fasta[[2]]
}
\dontshow{fasta.v <- fasta.v[1:30,]}
# Calculate zscore using (codon model)
codon <- dinuc.codon(fasta.v, permutations = 10)

}
\author{
Ali Mostafa Anwar \email{ali.mo.anwar@std.agr.cu.edu.eg} and Mohmed Soudy \email{MohmedSoudy2009@gmail.com}
}
