% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resource_manager.R
\docType{class}
\name{resource_manager}
\alias{resource_manager}
\title{Resource Manager}
\description{
This object manages all of the resources in a village.
}
\section{Methods}{

\describe{
\item{\code{initialize()}}{Creates a new manager}
\item{\code{get_resources()}}{Gets all of the resources that the manager has}
\item{\code{get_resource()}}{Retrieves a resource from the manager}
\item{\code{add_resource()}}{Adds a resource to the manager}
\item{\code{remove_resource()}}{Removes a resource from the manager}
\item{\code{get_resource_index()}}{Retrieves the index of the resource}
\item{\code{get_states()}}{Returns a list of states}
\item{\code{load()}}{Loads a csv file of resources and adds them to the manager.}
}
}

\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{resources}}{A list of resource objects}

\item{\code{resource_class}}{The class used to represent resources
Creates a new , empty, resource manager for a village.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-resource_manager-new}{\code{resource_manager$new()}}
\item \href{#method-resource_manager-get_resources}{\code{resource_manager$get_resources()}}
\item \href{#method-resource_manager-get_resource}{\code{resource_manager$get_resource()}}
\item \href{#method-resource_manager-add_resource}{\code{resource_manager$add_resource()}}
\item \href{#method-resource_manager-remove_resource}{\code{resource_manager$remove_resource()}}
\item \href{#method-resource_manager-get_resource_index}{\code{resource_manager$get_resource_index()}}
\item \href{#method-resource_manager-get_states}{\code{resource_manager$get_states()}}
\item \href{#method-resource_manager-load}{\code{resource_manager$load()}}
\item \href{#method-resource_manager-clone}{\code{resource_manager$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-resource_manager-new"></a>}}
\if{latex}{\out{\hypertarget{method-resource_manager-new}{}}}
\subsection{Method \code{new()}}{
Get a new instance of a resource_manager
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{resource_manager$new(resource_class = villager::resource)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{resource_class}}{The class being used to describe the resources being managed
Gets all of the managed resources}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-resource_manager-get_resources"></a>}}
\if{latex}{\out{\hypertarget{method-resource_manager-get_resources}{}}}
\subsection{Method \code{get_resources()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{resource_manager$get_resources()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list of resources
Gets a resource given a resource name
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-resource_manager-get_resource"></a>}}
\if{latex}{\out{\hypertarget{method-resource_manager-get_resource}{}}}
\subsection{Method \code{get_resource()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{resource_manager$get_resource(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name of the requested resource}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A resource object
Adds a resource to the manager.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-resource_manager-add_resource"></a>}}
\if{latex}{\out{\hypertarget{method-resource_manager-add_resource}{}}}
\subsection{Method \code{add_resource()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{resource_manager$add_resource(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{The resources to add}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
Removes a resource from the manager
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-resource_manager-remove_resource"></a>}}
\if{latex}{\out{\hypertarget{method-resource_manager-remove_resource}{}}}
\subsection{Method \code{remove_resource()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{resource_manager$remove_resource(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name of the resource being removed}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
Returns the index of a resource in the internal resource list
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-resource_manager-get_resource_index"></a>}}
\if{latex}{\out{\hypertarget{method-resource_manager-get_resource_index}{}}}
\subsection{Method \code{get_resource_index()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{resource_manager$get_resource_index(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name of the resource being located}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The index in the list, or R's default return value
Returns a data.frame where each row is a resource.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-resource_manager-get_states"></a>}}
\if{latex}{\out{\hypertarget{method-resource_manager-get_states}{}}}
\subsection{Method \code{get_states()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{resource_manager$get_states()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Subclasses should not have to override this method because it takes all member variables into account
}

\subsection{Returns}{
A single data.frame
Loads a csv file of resources into the manager
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-resource_manager-load"></a>}}
\if{latex}{\out{\hypertarget{method-resource_manager-load}{}}}
\subsection{Method \code{load()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{resource_manager$load(file_name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file_name}}{The path to the csv file}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-resource_manager-clone"></a>}}
\if{latex}{\out{\hypertarget{method-resource_manager-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{resource_manager$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
