% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/10_shortIronButterflyPnL.R
\name{shortIronButterflyPnL}
\alias{shortIronButterflyPnL}
\title{Calculates per share Profit and Loss (PnL) at expiration for Short Iron Butterfly Option Strategy and draws its Bar Plot displaying PnL in the Plots tab.}
\usage{
shortIronButterflyPnL(
  ST,
  X1L,
  X2M,
  X3H,
  P1L,
  P2,
  C2,
  C3H,
  hl = 0,
  hu = 2,
  spot = spot,
  pl = pl,
  myData = myData,
  myTibble = myTibble,
  PnL = PnL
)
}
\arguments{
\item{ST}{Spot Price at time T.}

\item{X1L}{Lower Strike Price or eXercise price for one ITM shorted Put.}

\item{X2M}{Medium trike Price or eXercise price for  one bought Put and one bought Call.}

\item{X3H}{Higher Strike Price or eXercise price for one OTM shorted Call.}

\item{P1L}{Put Premium or Put Price received for the first ITM shorted Put.}

\item{P2}{Put Premium or Put Price paid for the bought Put.}

\item{C2}{Put Premium or Put Price paid for the bought Call.}

\item{C3H}{Call Premium or Put Price received for the one OTM shorted Call.}

\item{hl}{lower bound value for setting lower-limit of x-axis displaying spot price.}

\item{hu}{upper bound value for setting upper-limit of x-axis displaying spot price.}

\item{spot}{Spot Price}

\item{pl}{Profit and Loss}

\item{myData}{Data frame}

\item{myTibble}{tibble}

\item{PnL}{Profit and Loss}
}
\value{
graph of the strategy
}
\description{
This volatility strategy is a combination of a bear put spread and a bull call spread and consists of a short position in an OTM put option (out of the money put : put Strike price is lower than spot price )  with a strike price X1L, a long position in an ATM (at the money)  put option and an ATM (at the money)  call option with a strike price X2M, and a short position in an OTM call option (out of the money call : call Strike price is higher than spot price ) with a strike price X3H. The strikes are equidistant: X2M minus X1L equals to X3H minus X2M . This is a net debit trade. The trader or investor has an outlook that is  neutral (Kakushadze & Serur, 2018).
}
\details{
According to conceptual details given by Cohen (2015), and a closed form solution provided by Kakushadze and Serur (2018), this method is developed, and the given examples are created, to compute per share Profit and Loss at expiration for Short Iron Butterfly Option Strategy and draw its graph in the Plots tab.
}
\examples{
shortIronButterflyPnL(52,45,50,55,2,4,7,5)
shortIronButterflyPnL(405,400,410,420,8,12,14.5,9,hl=0.9,hu=1.1)
}
