% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Calculate_weights.R
\name{Calculate_weights}
\alias{Calculate_weights}
\title{Calculate inverse probability of selection weights.}
\usage{
Calculate_weights(dat)
}
\arguments{
\item{dat}{Data.frame with one row per individual with columns \emph{d}
non-censoring indicator; \strong{k} interval of (age) group; \strong{S_k}
population interval-based proportion of individuals experiencing the
event in intervals later than k; \strong{S_k.} sample
proportion of individuals experiencing the event in intervals later
than k.}
}
\value{
Vector with weights.
}
\description{
This function calculates weights to correct for ascertainment bias in
time-to-event data where clusters are outcome-dependently sampled,
for example high-risk families in genetic epidemiological studies in
cancer research.
}
\details{
Weights are based on a comparison between the survival between sample and
population. Therefore, besides the sample data, the population incidence rate
(per 100 000) is needed as input, as well as the cut-offs of the
(age/time-to-event) groups for which this is available. The function provides
two options for the latter: cut-offs can be provided manually or using the
standard 5- or 10-years (age) categories (0-4, 5-9, ... or 0-9, 10-14, ...).
Note that resulting intervals are of the form [xx, xx).
}
