% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webdeveloper.R
\name{dynamicTemplate2}
\alias{dynamicTemplate2}
\title{Replace placeholder variables in a HTML document string, after reading the file into R.}
\usage{
dynamicTemplate2(file, replacements = c())
}
\arguments{
\item{file}{Filepath of the HTML file with placeholder variables that need to be replaced.}

\item{replacements}{A named vector or named list. Names should match a template variable acting as a placeholder in a HTML document string
and values should be the text to replace the placeholders with.}
}
\value{
A string of HTML with placeholder values replaced.
}
\description{
Replace placeholder variables in a HTML document string, after reading the file into R.
}
\examples{
tmp <- tempfile()
writeLines(html(body(templateVar("body_var"))), con = tmp)
dynamicTemplate2(file = tmp, replacements = c("\%\%rvar-body_var\%\%" = div(p("body replacement"))))
}
