% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global.r2.R
\name{global.r2}
\alias{global.r2}
\title{Plots in a single window the R2 of each model.}
\usage{
global.r2(
  wpls = NULL,
  col.cal = "blue",
  col.cv = "red",
  col.strip.background = "orange",
  xlab = NULL,
  ylab = NULL,
  title = NULL
)
}
\arguments{
\item{wpls, }{object obtained from \strong{cv.wpls}.}

\item{col.cal, }{color for the calibration line.}

\item{col.cv, }{color for the cross-validation line.}

\item{col.strip.background, }{color of the banner for each window.}

\item{xlab, }{title of the x axis.}

\item{ylab, }{title of the y axis.}

\item{title, }{title of the plot.}
}
\value{
Plot of R2 of each spectra region used to compute PLS.
}
\description{
Plots in a single window the R2 of each model.
}
\examples{
data(beer)
conc=beer[,1]
sp=beer[,2:ncol(beer)]
names(sp)=convert.names.wl(1100,2250,2)
conc=unlist(conc)
mywpls=cv.wpls(sp, conc,mode='wpls', windows = 5)
global.r2(mywpls,col.cal='navy',
               col.cv='red',
               col.strip.background='orange',
               xlab='Component',
               ylab=expression(R^2))
}
