% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select.best.window.R
\name{sel.best.window}
\alias{sel.best.window}
\title{Selection of the best window computed with cv.wpls}
\usage{
sel.best.window(wpls = NULL)
}
\arguments{
\item{wpls, }{object obtained from cv.wpls.}
}
\value{
An object containing results of the best model. Has the same content of a model obtained from the function \strong{pls} of \strong{mdatools}.
}
\description{
Takes as input the object containing metrics of the several models computed
with cv.wpls and selects the best basing on the lowest RMSE available; then computes
PLS and gives as output an object containing results.
}
\examples{
data(beer)
conc=beer[,1]
sp=beer[,2:ncol(beer)]
names(sp)=convert.names.wl(1100,2250,2)
conc=unlist(conc)
mywpls=cv.wpls(sp, conc,mode='wpls', windows = 5)
best.pls=sel.best.window(mywpls)
}
