% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tokenization.R
\name{.wp_tokenize_word}
\alias{.wp_tokenize_word}
\title{Tokenize a Word}
\usage{
.wp_tokenize_word(word, vocab, unk_token = "[UNK]", max_chars = 100)
}
\arguments{
\item{word}{Word to tokenize.}

\item{vocab}{Character vector of vocabulary tokens. The tokens are assumed to
be in order of index, with the first index taken as zero to be compatible
with Python implementations.}

\item{unk_token}{Token to represent unknown words.}

\item{max_chars}{Maximum length of word recognized.}
}
\value{
Input word as a list of tokens.
}
\description{
Tokenize a single "word" (no whitespace). The word can technically contain
punctuation, but in BERT's tokenization, punctuation has been split out by
this point.
}
\keyword{internal}
