% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_import_functions.R
\name{read_ddf}
\alias{read_ddf}
\title{Import work loop or isometric data from .ddf files}
\usage{
read_ddf(
  file_name,
  file_id = NA,
  rename_cols = list(c(2, 3), c("Position", "Force")),
  skip_cols = 4:11,
  phase_from_peak = FALSE,
  ...
)
}
\arguments{
\item{file_name}{A .ddf file that contains data from a single workloop,
twitch, or tetanus experiment}

\item{file_id}{A string identifying the experiment. The file name is used by
default.}

\item{rename_cols}{List consisting of a vector of indices of columns to
rename and a vector of new column names. See Details.}

\item{skip_cols}{Numeric vector of column indices to skip. See Details.}

\item{phase_from_peak}{Logical, indicating whether percent phase of
stimulation should be recorded relative to peak length or relative to L0
(default)}

\item{...}{Additional arguments passed to/from other functions that work
with \code{read_ddf()}}
}
\value{
An object of class \code{workloop}, \code{twitch}, or \code{tetanus},
all of which inherit class \code{muscle_stim}. These objects behave like
\code{data.frames} in most situations but also store metadata from the ddf
as attributes.

The \code{muscle_stim} object's columns contain:
\item{Time}{Time}
\item{Position}{Length change of the muscle, uncorrected for gear ratio}
\item{Force}{Force, uncorrected for gear ratio}
\item{Stim}{When stimulation occurs, on a binary scale}

In addition, the following information is stored in the \code{data.frame}'s
attributes:
\item{sample_frequency}{Frequency at which samples were collected}
\item{pulses}{Number of sequential pulses within a stimulation train}
\item{total_cycles_lo}{Total number of oscillatory cycles (assuming sine
wave trajectory) that the muscle experienced. Cycles are defined with respect
to initial muscle length (L0-to-L0 as opposed to peak-to-peak).}
\item{amplitude}{amplitude of length change (again, assuming sine wave
trajectory)}
\item{cycle_frequency}{Frequency of oscillations (again, assuming sine wave
trajectory)}
\item{units}{The units of measurement for each column in the
\code{data.frame}. This might be the most important attribute so please check
 that it makes sense!}
}
\description{
\code{read_ddf} reads in workloop, twitch, or tetanus experiment data from
.ddf files.
}
\details{
Read in a .ddf file that contains data from an experiment. If
position and force do not correspond to columns 2 and 3 (respectively),
replace "2" and "3" within \code{rename_cols} accordingly. Similarly,
\code{skip_cols = 4:11} should be adjusted if more than 11 columns are
present and/or columns 4:11 contain important data.

Please note that there is no correction for gear ratio or further
manipulation of data. See \code{fix_GR} to adjust gear ratio. Gear ratio can
also be adjusted prior to analyses within the \code{analyze_workloop()}
function, the data import all-in-one function \code{read_analyze_wl()}, or
the batch analysis all-in-one \code{read_analyze_wl_dir()}.

Please also note that organization of data within the .ddf file is assumed to
conform to that used by Aurora Scientific's Dynamic Muscle Control and
Analysis Software. YMMV if using a .ddf file from another source. The
\code{as_muscle_stim()} function can be used to generate \code{muscle_stim}
objects if data are imported via another function. Please feel free to
contact us with any issues or requests.
}
\examples{

library(workloopR)

# import the workloop.ddf file included in workloopR
wl_dat <-read_ddf(system.file("extdata", "workloop.ddf",
                              package = 'workloopR'),
                  phase_from_peak = TRUE)


}
\seealso{
Other data import functions: 
\code{\link{as_muscle_stim}()},
\code{\link{get_wl_metadata}()},
\code{\link{read_analyze_wl_dir}()},
\code{\link{read_analyze_wl}()},
\code{\link{read_ddf_dir}()}
}
\author{
Vikram B. Baliga and Shreeram Senthivasan
}
\concept{data import functions}
