% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workloopR.R
\docType{package}
\name{workloopR-package}
\alias{workloopR}
\alias{workloopR-package}
\title{workloopR: Analysis of Work Loops and Other Data from Muscle Physiology Experiments}
\description{
Functions for the import, transformation, and analysis of data 
    from muscle physiology experiments. The work loop technique is used to 
    evaluate the mechanical work and power output of muscle. Josephson (1985) 
    <doi:10.1242/jeb.114.1.493> modernized the technique for
    application in comparative biomechanics. Although our initial motivation 
    was to provide functions to analyze work loop experiment data, as we 
    developed the package we incorporated the ability to analyze data from 
    experiments that are often complementary to work loops. There are currently 
    three supported experiment types: work loops, simple twitches, and tetanus 
    trials. Data can be imported directly from .ddf files or via an object 
    constructor function. Through either method, data can then be cleaned or 
    transformed via methods typically used in studies of muscle physiology. 
    Data can then be analyzed to determine the timing and magnitude of force 
    development and relaxation (for isometric trials) or the magnitude of work, 
    net power, and instantaneous power among other things (for work loops). 
    Although we do not provide plotting functions, all resultant objects are 
    designed to be friendly to visualization via either base-R plotting or 
    'tidyverse' functions.
 This package has been peer-reviewed by rOpenSci (v. 1.1.0).
}
\details{
Functions for the import, transformation, and analysis of muscle physiology
experiments. Currently supported experiment types: work loop, simple twitch,
and tetanus.

Data that are stored in .ddf format (e.g. generated by Aurora Scientific's
Dynamic Muscle Control and Analysis Software) are easily imported via
\code{read_ddf()}, \code{read_analyze_wl()}, or \code{read_analyze_wl_dir()}.
Doing so generates objects of class \code{muscle_stim}, which are formatted
to work nicely with workloopR's core functions. Data that are read from other
 file formats can be constructed into \code{muscle_stim} objects via
 \code{as_muscle_stim()}.

Prior to analyses, data can be transformed or corrected. Transformational
functions include gear ratio correction (\code{fix_GR()}), position inversion
(\code{invert_position()}), and subsetting of particular cycles within a work
loop experiment (\code{select_cycles()}).

Core data analytical functions include \code{analyze_workloop()} for work
loop files and \code{isometric_timing()} for twitches.
\code{analyze_workloop()} computes instantaneous velocity, net work,
instantaneous power, and net power for work loop experiments on a per-cycle
basis. \code{isometric_timing()} provides summarization of twitch kinetics.

Some functions are readily available for batch processing of files. The
\code{read_analyze_wl_dir()} function allows for the batch import, cycle
selection, gear ratio correction, and ultimately work & power computation for
all work loop experiment files within a specified directory. The
\code{get_wl_metadata()} and \code{summarize_wl_trials()} functions organize
scanned files by recency (according to their time of last modification:
'mtime') and then report work and power output in the order that trials were
run. This ultimately allows for the \code{time_correct()} function to correct
 for degradation of the muscle (according to power & work) over time,
 assuming that the first and final trials are identical in experimental
 parameters.

Please feel free to contact either Vikram or Shree with suggestions or code
development requests (see contact info below). We are especially interested
in expanding our data import functions to accommodate file types other than
.ddf in future versions of workloopR.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://docs.ropensci.org/workloopR/}
  \item \url{https://github.com/ropensci/workloopR/}
  \item Report bugs at \url{https://github.com/ropensci/workloopR/issues/}
}

}
\author{
\strong{Maintainer}: Vikram B. Baliga \email{vbaliga87@gmail.com} (\href{https://orcid.org/0000-0002-9367-8974}{ORCID})

Authors:
\itemize{
  \item Shreeram Senthivasan \email{shreeramsenthi@gmail.com} (\href{https://orcid.org/0000-0002-7118-9547}{ORCID})
}

Other contributors:
\itemize{
  \item Julia Romanowska \email{Julia.Romanowska@uib.no} (Julia reviewed the package for rOpenSci
             , see <https://github.com/ropensci/software-review/issues/326/>) [reviewer]
  \item Eric Brown \email{eb@ericebrown.com} (Eric reviewed the package for rOpenSci
             , see <https://github.com/ropensci/software-review/issues/326/>) [reviewer]
}

}
\keyword{internal}
