% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package-doc.R
\docType{package}
\name{workspace}
\alias{workspace-package}
\alias{workspace}
\title{Manage Collections of Datasets and Objects}
\description{
Create, store, read and manage structured collections of
datasets and other objects using a 'workspace', then bundle it into a
compressed archive.  Using open and interoperable formats makes it
possible to exchange bundled data from 'R' to other languages such as
'Python' or 'Julia'.  Multiple formats are supported 'Parquet',
'JSON', 'yaml', spatial data and raster data are supported.

Examples of usage are:
\itemize{
\item Creating a collection of datasets and parameters to save in a zip file.
\item Importing and exporting datasets and settings into from a shiny app.
}

To get started with workspace, you will need to create an empty one with
\code{\link[=new_workspace]{new_workspace()}} or unpack an existing workspace zip file with
\code{\link[=unpack_workspace]{unpack_workspace()}}. These functions return a list with class workspace that
which you can interact with using the following functions.
}
\section{Storing and reading workspace data}{


To store data:
\itemize{
\item \code{\link[=store_dataset]{store_dataset()}} for data.frames, sf and splatRaster
\item \code{\link[=store_json]{store_json()}} for json strings
\item \code{\link[=store_rds]{store_rds()}} for R objects
\item \link{store_yaml} for storing a list in YAML format
}

Each object stored in a workspace will have an associated name which can then be used
to retrieve the data with the following functions:
\itemize{
\item For interactive use, \code{\link[=print]{print()}} the workspace to the console to show the directory
of the workspace and its contents
\item \code{\link[=list_object_in_workspace]{list_object_in_workspace()}} to list objects in a workspace
\item \code{\link[=read_timestamp]{read_timestamp()}} to read a timestamp associated with an object of a
workspace. Each time an object is stored, the timestamp is recorded
\item \code{\link[=read_dataset_in_workspace]{read_dataset_in_workspace()}} to read a dataset in a workspace
\item \code{\link[=read_raster_in_workspace]{read_raster_in_workspace()}} to read a raster file in a workspace
\item \code{\link[=read_rds_in_workspace]{read_rds_in_workspace()}} to read an Rds file in a workspace
\item \code{\link[=read_json_str_in_workspace]{read_json_str_in_workspace()}} to read a JSON string in a workspace
\item \code{\link[=read_yaml_in_workspace]{read_yaml_in_workspace()}} to read a YAML file in a workspace
}

Stored objects can be removed with:
\itemize{
\item \code{\link[=rm_object_in_workspace]{rm_object_in_workspace()}} for any object
\item \code{\link[=delete_dataset]{delete_dataset()}} for datasets
}
}

\section{Workspace management}{


A workspace an also be compressed into a zip file using \code{\link[=pack_workspace]{pack_workspace()}}
and unzipped using \code{\link[=unpack_workspace]{unpack_workspace()}}, which allows for saving a workspace
to reuse later or share a zip file with someone else.

Workspaces can be cloned using \code{\link[=workspace_copy]{workspace_copy()}} or merged together with
\code{\link[=workspace_bind]{workspace_bind()}}.
}

\section{Dataset formats}{


Tabular datasets, such as objects of class \code{data.frame} or \code{tibble} are stored
as \code{Parquet} files. Geosptial formats are supported using \code{\link[=store_dataset]{store_dataset()}}
for \code{splatRaster} objects from the \code{terra} package and \code{sf} objects from the
\code{sf} package.
}

\section{What is a workspace?}{


A \code{workspace} object is a list with class \code{workspace} with 2 elements; a directory folder
and version number.

The former is where the files are stored and read from, and the latter,
contains a version number for the \code{workspace} structure in case new versions
are required in future. A \code{workspace} therefore represents a folder and its files.

Note, to ensure validity of workspaces, they should be created and modified
with functions from this package, not manually.
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/ardata-fr/workspace}
  \item Report bugs at \url{https://github.com/ardata-fr/workspace/issues}
}

}
\author{
\strong{Maintainer}: Eli Daniels \email{eli.daniels@ardata.fr}

Authors:
\itemize{
  \item David Gohel \email{david.gohel@ardata.fr}
}

Other contributors:
\itemize{
  \item ArData [copyright holder, funder]
}

}
